% Keithley KPCI-3108
% Ananlog Input
ai = analoginput('keithley',0); % create device object
% Define Parameters
Ch=0;
sfreq = 40000;
nPoints = 2000;

chan = addchannel(ai,Ch); % ch 0,1
%set sampling rate to 1kHz and collect 1 sec worth of data
set(chan,'InputRange',[-10 10])
set(ai,'SampleRate',sfreq)
set(ai,'SamplesPerTrigger',nPoints) % # of data points

start(ai)   %start the acquisition
data = getdata(ai); %move the data from the engine
plot(data(1:200))  %plot it

delete(ai)  %clear the memory
clear ai